﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Reactive;
using System.IO;
using RxAsynchronousHelper;

namespace ClipboardRelayPhone
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();
        }

        private void copyButton_Click(object sender, RoutedEventArgs e)
        {
            statusText.Text = "";
            WebRequest.Create("http://localhost:32888/get/?" + Environment.TickCount)
                .DownloadStringAsync()
                .ObserveOnDispatcher()
                .Subscribe(
                    s =>
                    {
                        Clipboard.SetText(s);
                        statusText.Text = "copied.";
                        if (s.StartsWith("http://") || s.StartsWith("https://"))
                        {
                            if (MessageBox.Show("URL detected. Open it?", "Copy", MessageBoxButton.OKCancel) == MessageBoxResult.OK)
                            {
                                var task = new Microsoft.Phone.Tasks.WebBrowserTask();
                                task.Uri = new Uri(s);
                                task.Show();
                            }
                        }
                    },
                    ex => MessageBox.Show(ex.ToString())
                ); 
        }

        private void sendButton_Click(object sender, RoutedEventArgs e)
        {
            statusText.Text = "";
            byte[] buf = System.Text.Encoding.UTF8.GetBytes(Clipboard.GetText());

            WebRequest.Create("http://localhost:32888/set/?" + Environment.TickCount)
                .UploadDataAsync(buf)
                .SelectMany(res => res.DownloadStringAsync())
                .ObserveOnDispatcher()
                .Subscribe(
                    s => { statusText.Text = "sent."; },
                    ex => MessageBox.Show(ex.ToString())
                );
        }
    }
}