﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;
using System.Windows.Forms;

namespace ClipboardRelayServer
{
    class Program
    {
        [STAThreadAttribute]
        static void Main(string[] args)
        {
            string prefix = "http://localhost:32888/"; // 受け付けるURL

            HttpListener listener = new HttpListener();
            listener.Prefixes.Add(prefix); // プレフィックスの登録
            try
            {
                listener.Start();
            }
            catch (Exception)
            {
                Console.WriteLine("Access denied. please execute \"netsh http add urlacl url=http://localhost:32888/ user=\\username\" in administrator command prompt.");
                return;
            }

            Console.WriteLine("Start server");

            while (true)
            {
                HttpListenerContext context = listener.GetContext();
                HttpListenerRequest req = context.Request;
                HttpListenerResponse res = context.Response;

                Console.WriteLine(req.RawUrl);

                // リクエストされたURLからファイルのパスを求める
                if (req.RawUrl.StartsWith("/get/"))
                {
                    res.ContentType = "text/plain";
                    using (StreamWriter writer = new StreamWriter(res.OutputStream))
                    {
                        writer.Write(Clipboard.GetText());
                    }
                }
                else if (req.RawUrl.StartsWith("/set/"))
                {
                    using (StreamReader reader = new StreamReader(req.InputStream))
                    {
                        Clipboard.SetText(reader.ReadToEnd());
                    }
                    using (StreamWriter writer = new StreamWriter(res.OutputStream))
                    {
                        writer.Write("ok");
                    }
                }
                else
                {
                    res.StatusCode = 404;
                }

                // ファイルが存在すればレスポンス・ストリームに書き出す
                res.Close();
            }
        }
    }
}
