﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Xml.Linq;
using Microsoft.Phone.Reactive;
using System.IO;

namespace FotolifeView
{
    public partial class MainPage : PhoneApplicationPage
    {
        const string rssSpace = "{http://purl.org/rss/1.0/}";
        const string contentSpace = "{http://purl.org/rss/1.0/modules/content/}";
        const string dcSpace = "{http://purl.org/dc/elements/1.1/}";
        const string hatenaSpace = "{http://www.hatena.ne.jp/info/xmlns#}";

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            // Set the data context of the listbox control to the sample data
            DataContext = App.ViewModel;
            this.Loaded += new RoutedEventHandler(MainPage_Loaded);

            // 画像の読み込み
            LoadImageListBox("http://f.hatena.ne.jp/userlist?mode=rss", newPhotoListBox);
            LoadImageListBox("http://f.hatena.ne.jp/hotfoto?mode=rss", hotPhotoListBox);
            LoadImageListBox("http://f.hatena.ne.jp/iseebi/rss?mode=rss", userPhotoListBox);

            newPhotoListBox.SelectionChanged += new SelectionChangedEventHandler(photoListBox_SelectionChanged);
            hotPhotoListBox.SelectionChanged += new SelectionChangedEventHandler(photoListBox_SelectionChanged);
            userPhotoListBox.SelectionChanged += new SelectionChangedEventHandler(photoListBox_SelectionChanged);
        }

        void photoListBox_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (e.AddedItems.Count > 0)
            {
                HatenaFotolifeRssItem item = (HatenaFotolifeRssItem)e.AddedItems[0];
                NavigationService.Navigate(new Uri(string.Format("/ImagePage.xaml?image={0}", item.ImageUrl), UriKind.Relative));
            }
        }

        // Load data for the ViewModel Items
        private void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            if (!App.ViewModel.IsDataLoaded)
            {
                App.ViewModel.LoadData();
            }
        }

        public void LoadImageListBox(string url, ListBox targetList)
        {
            WebClient c = new WebClient();

            Observable.FromEvent<DownloadStringCompletedEventArgs>(c, "DownloadStringCompleted")
                .Select(p => XDocument.Load(new StringReader(p.EventArgs.Result)))
                .ObserveOnDispatcher()
                .Do(p =>
                {
                    var q = from elem in p.Root.Elements()
                            where elem.Name.ToString().EndsWith("item")
                            select new HatenaFotolifeRssItem()
                           {
                               Title = elem.Element(rssSpace + "title").Value,
                               Link = elem.Element(rssSpace + "link").Value,
                               Description = elem.Element(rssSpace + "description").Value,
                               Content = elem.Element(contentSpace + "encoded").Value,
                               Date = elem.Element(dcSpace + "date").Value,
                               ImageUrl = elem.Element(hatenaSpace + "imageurl").Value,
                               ImageUrlSmall = elem.Element(hatenaSpace + "imageurlsmall").Value,
                               ImageUrlMedium = elem.Element(hatenaSpace + "imageurlmedium").Value,
                               Syntax = elem.Element(hatenaSpace + "syntax").Value,
                               Colors = (from color in elem.Element(hatenaSpace + "colors").Elements() where color.Name == hatenaSpace + "color" select color.Value).ToArray<string>()
                           };
                    targetList.ItemsSource = q;
                })
                .Subscribe();

            c.DownloadStringAsync(new Uri(url));
        }
    }
}